/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.ExternalStorageCacheFluid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class StorageExternalFluid
implements IStorageExternal<FluidStack> {
    private final IExternalStorageContext context;
    private final Supplier<IFluidHandler> handlerSupplier;
    private final boolean connectedToInterface;
    private final ExternalStorageCacheFluid cache = new ExternalStorageCacheFluid();

    public StorageExternalFluid(IExternalStorageContext context, Supplier<IFluidHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Nullable
    private IFluidTankProperties[] getProperties() {
        IFluidHandler handler = this.handlerSupplier.get();
        return handler != null && handler.getTankProperties() != null && handler.getTankProperties().length != 0 ? handler.getTankProperties() : null;
    }

    @Override
    public void update(INetwork network) {
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        this.cache.update(network, this.handlerSupplier.get());
    }

    @Override
    public long getCapacity() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            long capacity = 0L;
            for (IFluidTankProperties properties : props) {
                capacity += (long)properties.getCapacity();
            }
            return capacity;
        }
        return 0L;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (IFluidTankProperties properties : props) {
                FluidStack stack = properties.getContents();
                if (stack == null) continue;
                fluids.add(stack);
            }
            return fluids;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<StackListEntry<FluidStack>> getEntries() {
        ArrayList<StackListEntry<FluidStack>> list = new ArrayList<StackListEntry<FluidStack>>();
        for (FluidStack s : this.getStacks()) {
            list.add(new StackListEntry<FluidStack>(s, s.amount));
        }
        return list;
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> insert(@Nonnull FluidStack stack, long size, Action action) {
        if (this.context.acceptsFluid(stack)) {
            IFluidHandler handler = this.handlerSupplier.get();
            if (handler == null) {
                return new StackListResult<FluidStack>(stack.copy(), size);
            }
            while (size > 1L) {
                int filled = handler.fill(StackUtils.copy(stack, size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size), action == Action.PERFORM);
                size -= (long)filled;
                if (filled == Integer.MAX_VALUE) continue;
                break;
            }
            if (size < 1L) {
                return null;
            }
        }
        return new StackListResult<FluidStack>(stack.copy(), size);
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> extract(@Nonnull FluidStack stack, long size, int flags, Action action) {
        FluidStack drained;
        IFluidHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        long extracted = 0L;
        while (size > 1L && (drained = handler.drain(StackUtils.copy(stack, size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size), action == Action.PERFORM)) != null) {
            extracted += (long)drained.amount;
            size -= (long)drained.amount;
            if (drained.amount == Integer.MAX_VALUE) continue;
            break;
        }
        return new StackListResult<FluidStack>(stack.copy(), extracted);
    }

    @Override
    public long getStored() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            int stored = 0;
            for (IFluidTankProperties properties : props) {
                FluidStack contents = properties.getContents();
                if (contents == null) continue;
                stored += contents.amount;
            }
            return stored;
        }
        return 0L;
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0L;
        }
        return remainder < 1L ? size : size - remainder;
    }
}

